import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viser_remit/core/route/route.dart';
import 'package:viser_remit/core/utils/dimensions.dart';
import 'package:viser_remit/core/utils/my_color.dart';
import 'package:viser_remit/core/utils/my_images.dart';
import 'package:viser_remit/core/utils/my_strings.dart';
import 'package:viser_remit/core/utils/style.dart';
import 'package:viser_remit/data/controller/home/home_controller.dart';
import 'package:viser_remit/data/repo/account/profile_repo.dart';
import 'package:viser_remit/view/components/bottom-sheet/custom_bottom_sheet.dart';
import 'package:viser_remit/view/components/divider/custom_divider.dart';
import 'package:viser_remit/view/screens/bottom_nav_section/profile/widget/delete_account_bottom_sheet_body.dart';
import 'package:viser_remit/view/screens/bottom_nav_section/profile/widget/header_section.dart';
import 'package:viser_remit/view/screens/bottom_nav_section/profile/widget/profile_item_widget.dart';
import '../../../../core/utils/util.dart';
import '../../../../data/controller/account/profile_controller.dart';
import '../../../../data/services/api_client.dart';
import '../../../components/app-bar/viser_remit_app_bar.dart';

class ProfileScreen extends StatefulWidget {
  const ProfileScreen({super.key});
  @override
  State<ProfileScreen> createState() => _ProfileScreenState();
}

class _ProfileScreenState extends State<ProfileScreen> {
  @override
  void initState() {
    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(ProfileController(profileRepo: Get.put(ProfileRepo(apiClient: Get.find()))));
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<ProfileController>(
      builder: (controller) => Scaffold(
        appBar: ViserRemitAppBar(
          title: MyStrings.profile.tr,
          isElevation: true,
          isShowLeading: false,
          
        ),
        body: SingleChildScrollView(
          physics: const BouncingScrollPhysics(),
          padding: const EdgeInsets.symmetric(horizontal: Dimensions.space16, vertical: Dimensions.space20),
          child: Container(
            padding: const EdgeInsetsDirectional.symmetric(horizontal: Dimensions.space20, vertical: Dimensions.space5),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(Dimensions.space10),
              color: MyColor.getCardBgColor(),
              boxShadow: MyUtils.getCardShadow(),
            ),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                const SizedBox(height: Dimensions.space25),
                GestureDetector(
                  onTap: () {
                    Get.toNamed(RouteHelper.editProfileScreen);
                  },
                  child: const HeaderSectionProfile(),
                ),
                const CustomDivider(),
                Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Text(
                      MyStrings.sendMoney.tr,
                      style: boldMediumLarge,
                    ),
                    const SizedBox(height: Dimensions.space16),
                    ProfileItemWidget(
                      onTap: () {
                        var homeController = Get.find<HomeController>();
                        homeController.setSendMoneyScreenOptionalItem(false);
                        homeController.sendingAmountController.clear();
                        homeController.receivingAmountController.clear();
                        Get.toNamed(RouteHelper.senderScreen);
                      },
                      svgImage: MyImages.sendMoney,
                      title: MyStrings.sendMoney.tr,
                    ),
                    ProfileItemWidget(
                      onTap: () => Get.toNamed(RouteHelper.sendMoneyHistory, arguments: true),
                      svgImage: MyImages.viewHistory,
                      title: MyStrings.viewHistory.tr,
                    ),
                  ],
                ),
                const CustomDivider(),
                Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Text(
                      MyStrings.transaction.tr,
                      style: boldMediumLarge,
                    ),
                    const SizedBox(height: Dimensions.space8),
                    ProfileItemWidget(
                      onTap: () => Get.toNamed(RouteHelper.transactionScreen, arguments: true),
                      svgImage: MyImages.transaction,
                      title: MyStrings.moneyTransaction.tr,
                    ),
                  ],
                ),
                const CustomDivider(),
                Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Text(
                      MyStrings.about.tr,
                      style: boldMediumLarge,
                    ),
                    const SizedBox(height: Dimensions.space8),
                    ProfileItemWidget(
                      onTap: () => Get.toNamed(RouteHelper.faqScreen, arguments: true),
                      svgImage: MyImages.faq,
                      title: MyStrings.faq.tr,
                    ),
                  ],
                ),
                const CustomDivider(),
                Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Text(
                      MyStrings.support.tr,
                      style: boldMediumLarge,
                    ),
                    const SizedBox(height: Dimensions.space8),
                    ProfileItemWidget(
                      onTap: () => Get.toNamed(RouteHelper.allTicketScreen, arguments: true),
                      svgImage: MyImages.supportTicket,
                      title: MyStrings.supportTicket.tr,
                    ),
                  ],
                ),
                const CustomDivider(),
                Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Text(
                      MyStrings.settingsAndSecurity.tr,
                      style: boldMediumLarge,
                    ),
                    const SizedBox(height: Dimensions.space8),
                    ProfileItemWidget(
                      onTap: () => Get.toNamed(RouteHelper.changePasswordScreen),
                      svgImage: MyImages.changePassword,
                      title: MyStrings.changePassword.tr,
                    ),
                    ProfileItemWidget(
                      onTap: () => Get.toNamed(RouteHelper.twoFactorSetupScreen),
                      svgImage: MyImages.twoFaAuth,
                      title: MyStrings.twoFactorAuthentication.tr,
                    ),
                    ProfileItemWidget(
                      onTap: () => Get.toNamed(RouteHelper.editProfileScreen),
                      svgImage: MyImages.settings,
                      title: MyStrings.profileSettings.tr,
                    ),
                    ProfileItemWidget(
                      onTap: () {
                        Get.toNamed(RouteHelper.languageScreen);
                      },
                      svgImage: MyImages.language,
                      title: MyStrings.language.tr,
                    ),
                    const CustomDivider(
                      space: 5,
                    ),
                    ProfileItemWidget(
                      onTap: () {
                        CustomBottomSheet(
                          isNeedMargin: true,
                          child: const DeleteAccountBottomSheetBody(),
                        ).customBottomSheet(context);
                      },
                      svgImage: MyImages.deleteAccount,
                      title: MyStrings.deleteAccount.tr,
                    ),
                    controller.logoutLoading
                        ? const Padding(
                            padding: EdgeInsetsDirectional.only(top: Dimensions.space15),
                            child: Align(
                              alignment: Alignment.center,
                              child: SizedBox(
                                height: 20,
                                width: 20,
                                child: CircularProgressIndicator(color: MyColor.primaryColor, strokeWidth: 2.00),
                              ),
                            ),
                          )
                        : ProfileItemWidget(
                            onTap: () => controller.logout(),
                            svgImage: MyImages.logout,
                            title: MyStrings.logout.tr,
                          ),
                    const SizedBox(height: 30),
                  ],
                ),
              ],
            ),
          ),
        ),
      ),
    );
  }
}
